/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.utils.data;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public class AnimationData {
    private final List<Pair<Integer, Integer>> frames = new ArrayList<Pair<Integer, Integer>>();

    public int getLength() {
        int time = 0;
        for (Pair<Integer, Integer> pair : this.frames) {
            time += ((Integer)pair.getRight()).intValue();
        }
        return time;
    }

    public Pair<Integer, Integer> getFrameByTime(long time) {
        Pair<Integer, Integer> pair;
        int frames = this.getFrames().size();
        int index = 0;
        for (long remainder = time % (long)this.getLength(); remainder > 0L; remainder -= (long)((Integer)pair.getRight()).intValue()) {
            pair = this.getFrames().get(index);
            index = index + 1 >= frames ? 0 : index + 1;
        }
        return this.getFrames().get(index);
    }

    public static AnimationData builder() {
        return new AnimationData();
    }

    public static AnimationData construct(int texHeight, int patternHeight, int frameTime) {
        AnimationData data = AnimationData.builder();
        for (int i = 0; i < texHeight / patternHeight; ++i) {
            data.frame(i, frameTime);
        }
        return data;
    }

    public AnimationData frame(int index, int time) {
        this.frames.add((Pair<Integer, Integer>)Pair.of((Object)index, (Object)time));
        return this;
    }

    public List<Pair<Integer, Integer>> getFrames() {
        return this.frames;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnimationData)) {
            return false;
        }
        AnimationData other = (AnimationData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Pair<Integer, Integer>> this$frames = this.getFrames();
        List<Pair<Integer, Integer>> other$frames = other.getFrames();
        return !(this$frames == null ? other$frames != null : !((Object)this$frames).equals(other$frames));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AnimationData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Pair<Integer, Integer>> $frames = this.getFrames();
        result = result * 59 + ($frames == null ? 43 : ((Object)$frames).hashCode());
        return result;
    }

    public String toString() {
        return "AnimationData(frames=" + String.valueOf(this.getFrames()) + ")";
    }
}

